﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace KursBeispiele
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            //Können die Einträge der ListBox auch selbst zeichnen - eine Zeile reicht aus
            //Die Details über das Zeichnen (GDI+) kommen später!
            listBox1.DrawMode = DrawMode.OwnerDrawFixed;
            listBox1.ItemHeight = 40;

            //Methodentabseite auffüllen
            FillFunctionsTab();
        }

        private void FillFunctionsTab()
        {
            //Spezialordner Enumeration Namen laden
            string[] specialFolders = Enum.GetNames(typeof(Environment.SpecialFolder));
            //Namen der ComboBox hinzufügen
            comboBox1.Items.AddRange(specialFolders);
            //Standardelement auswählen - wissen, dass Zahl > 0 sein wird
            comboBox1.SelectedIndex = 0;

            //Die Umgebungsvariablen laden
            System.Collections.IDictionary vars = Environment.GetEnvironmentVariables();

            //Und einzeln hinzufügen
            foreach (string key in vars.Keys)
                comboBox2.Items.Add(key);

            //Standardelement auswählen - entweder 0 (Elemente > 0) oder -1 (Elemente == 0)
            comboBox2.SelectedIndex = Math.Min(comboBox2.Items.Count - 1, 0);

            //Laufwerke hinzufügen
            listBox2.Items.AddRange(Environment.GetLogicalDrives());
        }

        //Reload Button
        private void button1_Click(object sender, EventArgs e)
        {
            Form1_Load(sender, e);
        }

        //Das Load Ereignis kann oft sehr nützlich sein
        private void Form1_Load(object sender, EventArgs e)
        {
            listBox1.Items.Clear();
            AddProperty("CommandLine", Environment.CommandLine);
            AddProperty("CurrentDirectory", Environment.CurrentDirectory);
            AddProperty("MachineName", Environment.MachineName);
            AddProperty("OSVersion", Environment.OSVersion.ToString());
            AddProperty("ProcessorCount", Environment.ProcessorCount.ToString());
            AddProperty("StackTrace", Environment.StackTrace);
            AddProperty("SystemDirectory", Environment.SystemDirectory);
            AddProperty("TickCount", Environment.TickCount.ToString());
            AddProperty("UserDomainName", Environment.UserDomainName);
            AddProperty("UserName", Environment.UserName);
            AddProperty("Version", Environment.Version.ToString());
            AddProperty("WorkingSet", Environment.WorkingSet.ToString());
        }

        //Hilfsfunktion um Aufrufe zu sparen!
        private void AddProperty(string name, string value)
        {
            listBox1.Items.Add(new MyProperty(name, value));
        }

        //Mal mit dem eigenen Zeichnen der Einträge
        private void listBox1_DrawItem(object sender, DrawItemEventArgs e)
        {
            if(e.Index == -1)
                return;

            Rectangle top = e.Bounds;
            top.Height /= 2;
            Rectangle bottom = top;
            bottom.Offset(0, top.Height);
            top.Offset(20, 0);
            top.Width -= 20;

            MyProperty prop = listBox1.Items[e.Index] as MyProperty ?? MyProperty.Empty;
            e.DrawBackground();
            e.DrawFocusRectangle();
            e.Graphics.DrawImage(Resource1.prop, new Point(top.X - 18, top.Y + 2));
            TextRenderer.DrawText(e.Graphics, prop.Name, new Font(Font, FontStyle.Bold),
                top, e.ForeColor, TextFormatFlags.Left | TextFormatFlags.VerticalCenter);
            TextRenderer.DrawText(e.Graphics, prop.Value, Font,
                bottom, Color.SteelBlue, TextFormatFlags.Left | TextFormatFlags.VerticalCenter);
        }

        //Wechseln der ComboBox mit den Spezialordnernamen
        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            TypeConverter a = TypeDescriptor.GetConverter(typeof(Environment.SpecialFolder));
            Environment.SpecialFolder sf = (Environment.SpecialFolder)a.ConvertFromString(comboBox1.SelectedItem.ToString());
            textBox1.Text = Environment.GetFolderPath(sf);
        }

        //Wechseln der ComboBox mit den Umgebungsvariablen
        private void comboBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            textBox2.Text = Environment.GetEnvironmentVariable(comboBox2.SelectedItem.ToString());
        }

        //Zeichnet die Laufwerke
        private void listBox2_DrawItem(object sender, DrawItemEventArgs e)
        {
            //Überprüfen ob dies überhaupt möglich ist
            if (e.Index == -1)
                return;

            //Hintergrund usw. zeichnen
            e.DrawBackground();
            e.DrawFocusRectangle();

            //Using tut die Referenz danach sofort vernichten - sehr sauber!
            using (Graphics g = e.Graphics)
            {
                //Laufwerksinformationen holen
                string drive = listBox2.Items[e.Index].ToString();
                DriveInfo di = new DriveInfo(drive);
                Image driveImg = null;

                //Logo fürs Laufwerk
                switch (di.DriveType)
                {
                    case DriveType.CDRom:
                        driveImg = Resource1.drive_cd;
                        break;
                    case DriveType.Network:
                        driveImg = Resource1.drive_network;
                        break;
                    case DriveType.Removable:
                        driveImg = Resource1.drive_disk;
                        break;
                    default:
                        driveImg = Resource1.drive;
                        break;
                }

                //Zeichnen
                g.DrawImage(driveImg, new Point(e.Bounds.Left + 2, e.Bounds.Top + 1));

                TextRenderer.DrawText(g, di.IsReady ? di.VolumeLabel + " (" + di.Name + ")" : di.Name, Font,
                    new Point(e.Bounds.Left + 35, e.Bounds.Top + 1), e.ForeColor);

                Rectangle progress = new Rectangle(e.Bounds.Left + 35, e.Bounds.Top + 16, 
                    e.Bounds.Width - 150, e.Bounds.Height - 24);

                //Progress-Bar vorzeichnen
                Rectangle progressDone = progress;
                progressDone.Width = di.IsReady ? (int)((long)progress.Width - (long)progress.Width * di.AvailableFreeSpace / di.TotalSize) : 0;
                g.FillRectangle(Brushes.WhiteSmoke, progress);

                //Schöne Progress-Bar durch Gradienten
                g.FillRectangle(new System.Drawing.Drawing2D.LinearGradientBrush(progress, Color.SteelBlue, 
                    Color.LightBlue, System.Drawing.Drawing2D.LinearGradientMode.Vertical), progressDone);

                g.DrawRectangle(Pens.Black, progress);
            }
        }
    }
}
